    <?php 
        /**
        *
        * copyright (c) 2013-2023 Heliac Technologies
        * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
        *
        * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
        */
    ?>

    <div class="<?= $impostazioni["classeElementiStatisticiPerRigaHomeAdmin"] ?>">
        <div class="card mb-4 accordion box-shadow-lite">
            <div class="card-header collapsed" data-toggle="collapse" href="#utentiInattivi">
                <a class="card-title">
                    Contenuti piu commentati
                </a>
            </div>
            <div id="utentiInattivi" class="collapse show">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr class="d-flex">
                                    <th scope="col" class="col-1">#</th>
                                    <th scope="col" class="col-6">Titolo</th>
                                    <th scope="col" class="col-5">Commenti</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $ricerca->setTabella("geecB_contenuti AS c");
                                    $ricerca->setOrdinamento("ORDER BY (SELECT COUNT(*) FROM geecB_commenti WHERE idContenuto=c.id) DESC");
                                    $risUtentiPiuAttivi = $ricerca->eseguiRicerca(1);
                                    while($contenuto = $risUtentiPiuAttivi->fetch_assoc()) {
                                        $numeroCommenti = $geecomDb->contaRigheTabella("geecB_commenti",array("idContenuto"=>$contenuto["id"]));
                                        $linkModificaContenuto = ($contenuto["tipo"]=="elementoPortfolio") ? "componenti/portfolio/creaElemento.php" : "creaContenuto.php";
                                        echo"<tr class=\"d-flex\">
                                            <th scope=\"row\" class=\"col-1 text-nowrap h6 m-0 d-flex align-items-center small\">{$contenuto["id"]}</th>
                                            <td class=\"col-6\"><a href=\"$linkModificaContenuto?id={$contenuto["id"]}\">{$contenuto["titolo"]}</a></td>
                                            <td class=\"col-5\">$numeroCommenti</td>
                                        </tr>";
                                    }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>	

    <div class="<?= $impostazioni["classeElementiStatisticiPerRigaHomeAdmin"] ?>">
        <div class="card mb-4 accordion box-shadow-lite">
            <div class="card-header collapsed" data-toggle="collapse" href="#ultimiCommenti">
                <a class="card-title">
                    Ultimi commenti
                </a>
            </div>
            <div id="ultimiCommenti" class="collapse show">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr class="d-flex">
                                    <th scope="col" class="col-1">#</th>
                                    <th scope="col" class="col-6">Testo</th>
                                    <th scope="col" class="col-5">In risposta a</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $ricerca->setParametriRicerca(array());
                                    $ricerca->setTabella("geecB_commenti");
                                    $ricerca->setOrdinamento("ORDER BY id DESC");
                                    $risCommenti = $ricerca->eseguiRicerca(1);
                                    while($commento = $risCommenti->fetch_assoc()) {
                                        $datiContenuto = $geecomDb->leggiSingolaRiga("geecB_contenuti",$commento["idContenuto"]);
                                        echo"<tr class=\"d-flex\">
                                            <th scope=\"row\" class=\"col-1 text-nowrap h6 m-0 d-flex align-items-center small\">{$commento["id"]}</th>
                                            <td class=\"col-6\">{$commento["testo"]}</td>
                                            <td class=\"col-5\"><a href=\"creaContenuto.php?id={$datiContenuto["id"]}\">{$datiContenuto["titolo"]}</a></td>
                                        </tr>";
                                    }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>